// Wczytywanie biblioteki Readline
if (! function_exists('readline')) {
    dl('readline.'. (((strtoupper(substr(PHP_OS,0,3))) == 'WIN')?'dll':'so'))
        or die("Wymagana biblioteka Readline\n");
}

// Wczytywanie klasy Console_Getopt
require 'Console/Getopt.php';

$o = new Console_Getopt;
$opts = $o->getopt($o->readPHPArgv(),'pm',array('pomoc','multiline'));

// Wyjcie z informacj o parametrach, jeli zostay one bdnie podane
if (PEAR::isError($opts)) {
    print $opts->getMessage();
    print "\n";
    usage();
}

// domylnie przetwarza wiersze, jak tylko zostan wpisane
$multiline = false;

foreach ($opts[0] as $opt) {
    // usuwanie wszystkich pocztkowych -s
    $opt[0] = preg_replace('/^-+/','',$opt[0]);

    // sprawdzanie pierwszego znaku argumentu
    switch($opt[0][0]) {
    case 'h':
        // wywietlenie pomocy
        usage();
        break;
    case 'm':
        $multiline = true;
        break;
    }
}

// ustawienie wywietlania bdw
ini_set('display_errors',false);
ini_set('log_errors',true);

// tworzenie tablicy uzupeniania dla Readline
$functions = get_defined_functions();
foreach ($functions['internal'] as $k => $v) {
    $functions['internal'][$k] = "$v(";
}
function function_list($line) {
    return $GLOBALS['functions']['internal'];
}
readline_completion_function('function_list');

$cmd = '';
$cmd_count = 1;

while (true) {
    // pobranie wiersza wejcia od uytkownika
    $s = readline("[$cmd_count]> ");
    // dodanie go do historii polece
    readline_add_history($s);
    // jeli wczony jest tryb wielolinijkowy:
    if ($multiline) {
        // jeli wpisano tylko "."
        if ('.' == rtrim($s)) {
            // wykonaj kod w eval()
            eval($cmd);
            // wyczy zebrany kod
            $cmd = '';
            // zwikszenie licznika wierszy
            $cmd_count++;
            // kolejne zapytanie w nowym wierszu
            print "\n";
        } else {
            /* w przeciwnym razie dodajemy nowy wiersz do zebranego kodu,
               dodajemy te znak nowego wiersza, aby komentarze z //
               dziaay poprawnie
            */
            $cmd .= $s."\n";;
        }
    } else {
        // jeli nie jest to tryb wielolinijkowy, wykonujemy wiersz
        eval($s);
        // zwikszamy licznik polece
        $cmd_count++;
        // nowe zapytanie w kolejnym wierszu
        print "\n";
    }
}

// wywietlanie pomocy
function usage() {
    $my_name = $argv[0];

    print<<<_USAGE_
Uycie: $my_name [-p|--pomoc] [-m|--multiline]

  -p, --pomoc: wywietlenie tego tekstu
  -m, --multiline: wykonanie wpisanego kodu dopiero po znalezieniu "." w
                   osobnym wierszu. Domylnie kady wiersz wykonywany 
                   jest zaraz po wpisaniu.    

_USAGE_;
    exit(-1);
}
